<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Attendance;
use App\Models\Leave;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

class AttendanceController extends Controller
{
public function showToday()
{
$user = Auth::user();
$today = now()->toDateString();

// Check for approved annual or sick leave on today
$onLeave = Leave::where('user_id', $user->id)
->where('status', 'approved')
->where('start_date', '<=', $today) ->where('end_date', '>=', $today)
    ->whereIn('type', ['annual', 'sick'])
    ->exists();

    if ($onLeave) {
          $attendance = Attendance::where('user_id', $user->id)->where('date', $today)->first();
     return view('attendance.today', compact('attendance'))->with('leaveMessage', 'You are on approved leave today.');
    }

    $attendance = Attendance::where('user_id', $user->id)->where('date', $today)->first();

    // dd($attendance);

    return view('attendance.today', compact('attendance'));
    }

    public function checkIn()
    {
    $userId = Auth::id();
    $today = now()->toDateString();

    if (Attendance::where('user_id', $userId)->where('date', $today)->exists()) {
    return back()->with('error', 'Already checked in today.');
    }

    Attendance::create([
    'user_id' => $userId,
    'date' => $today,
    'check_in' => now()->toTimeString(),
    ]);

    return back()->with('success', 'Checked in successfully.');
    }

    public function checkOut()
    {
    $userId = Auth::id();
    $today = now()->toDateString();

    $attendance = Attendance::where('user_id', $userId)->where('date', $today)->first();

    if (!$attendance || $attendance->check_out) {
    return back()->with('error', 'Invalid check-out.');
    }

    $workedHours = Carbon::parse($attendance->check_in)->diffInMinutes(now()) / 60;

    $status = $this->determineStatusAndDeductLeave($userId, $workedHours, $today);

    $attendance->update([
    'check_out' => now()->toTimeString(),
    'status' => $status,
    ]);

    return back()->with('success', "Checked out. Status: $status");
    }

protected function determineStatusAndDeductLeave($userId, $workedHours, $date)
{
    if ($workedHours >= 9) {
        return 'full';
    }

    if ($workedHours >= 7.5 && $workedHours < 9) { 
        return $this->handleLeaveQuota($userId, 'short', $date);
    }

    if ($workedHours >= 4.5 && $workedHours < 7.5) {
        return $this->handleLeaveQuota($userId, 'half', $date);
    }

    return $this->handleLeaveQuota($userId, 'absent', $date);
}

    protected function handleLeaveQuota($userId, $type, $date)
{
    $shortLeaveQuota = 2;
    $annualLeaveQuota = 14;

    // Total annual leave used so far (supports 0.5 increments)
    $annualUsed = Leave::where('user_id', $userId)
        ->where('type', 'annual')
        ->where('status', 'approved')
        ->whereYear('start_date', now()->year)
        ->sum('days'); // we'll track `days` as decimal (e.g. 1 or 0.5)

    $remainingAnnual = $annualLeaveQuota - $annualUsed;

    if ($type === 'short') {
        $shortUsedThisMonth = Leave::where('user_id', $userId)
            ->where('type', 'short')
            ->where('status', 'approved')
            ->whereMonth('start_date', now()->month)
            ->count();

        if ($shortUsedThisMonth < $shortLeaveQuota) {
            // ✅ Use short leave
            Leave::create([
                'user_id' => $userId,
                'type' => 'short',
                'start_date' => $date,
                'end_date' => $date,
                'days' => 0.0,
                'status' => 'approved',
                'reason' => 'Auto deducted short leave',
            ]);
            return 'short';
        }

        // ❗ Quota exceeded — try 0.5 day deduction from annual leave
        if ($remainingAnnual >= 0.5) {
            Leave::create([
                'user_id' => $userId,
                'type' => 'annual',
                'start_date' => $date,
                'end_date' => $date,
                'days' => 0.5,
                'status' => 'approved',
                'reason' => 'Deducted 0.5 day annual leave for extra short leave',
            ]);
            return 'half';
        }

        // ❌ No leave — mark absent
        return 'nopay';
    }

    if ($type === 'half') {
        if ($remainingAnnual >= 0.5) {
            Leave::create([
                'user_id' => $userId,
                'type' => 'annual',
                'start_date' => $date,
                'end_date' => $date,
                'days' => 0.5,
                'status' => 'approved',
                'reason' => '0.5 day annual leave for half-day work',
            ]);
            return 'half';
        }

        return 'nopay'; // ❌ No annual leave to cover half day
    }
      if ($type === 'absent') {
        if ($remainingAnnual >= 1) {
            Leave::create([
                'user_id' => $userId,
                'type' => 'annual',
                'start_date' => $date,
                'end_date' => $date,
                'days' => 1,
                'status' => 'approved',
                'reason' => '1 day annual leave ',
            ]);
            return 'absent';
        }

        return 'nopay'; // ❌ No annual leave to cover half day
    }

    return 'nopay'; // fallback
}

            }